<?php
require_once(dirname(__FILE__) . '/../../config/config.php');
require_once(dirname(__FILE__) . '/../functions.php');

try {
    session_start();

    if (!isset($_SESSION['USER']) || $_SESSION['USER']['auth_type'] != 1) {
        // ログインされていない場合はログイン画面へ
        header('Location: /admin/login.php');
        exit;
    }

    $pdo = connect_db();

    $sql = "SELECT * FROM user";
    $stmt = $pdo->query($sql);
    $user_list = $stmt->fetchAll();
} catch (Exception $e) {
    header('Location: /error.php');
    exit;
}
?>
<!doctype html>
<html lang="ja">

<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.1/dist/css/bootstrap.min.css" integrity="sha384-zCbKRCUGaJDkqS1kPbPd7TveP5iyJE0EjAuZQTgFLD2ylzuqKfdKlfG/eSrtxUkn" crossorigin="anonymous">

    <!-- fontawesome -->
    <link href="/lib/fontawesome-free-5.15.4-web/css/all.css" rel="stylesheet">

    <!-- Original CSS -->
    <link rel="stylesheet" href="/css/style.css">

    <title>社員一覧 | WoRKS</title>
</head>

<body class="text-center bg-info">

    <div>
        <img class="mb-4" src="/img/logo.svg" alt="WoRKS" width="80" height="80">
    </div>

    <form class="border rounded bg-white form-user-list" action="index.php">
        <h1 class="h3 my-3">月別リスト</h1>

        <table class="table table-bordered">
            <thead>
                <tr class="bg-light">
                    <th scope="col">社員番号</th>
                    <th scope="col">社員名</th>
                    <th scope="col">権限</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($user_list as $user) : ?>
                    <tr>
                        <td scope="row"><?= $user['user_no'] ?></td>
                        <td><a href="/admin/user_result.php?id=<?= $user['id'] ?>"><?= $user['name'] ?></a></td>
                        <td scope="row"><?php if ($user['auth_type'] == 1) echo '管理者' ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </form>

    <!-- Optional JavaScript; choose one of the two! -->

    <!-- Option 1: jQuery and Bootstrap Bundle (includes Popper) -->
    <script src="https://cdn.jsdelivr.net/npm/jquery@3.5.1/dist/jquery.slim.min.js" integrity="sha384-DfXdz2htPH0lsSSs5nCTpuj/zy4C+OGpamoFVy38MVBnE+IbbVYUew+OrCXaRkfj" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.1/dist/js/bootstrap.bundle.min.js" integrity="sha384-fQybjgWLrvvRgtW6bFlB7jaZrFsaBXjsOMm/tB9LTS58ONXgqbR9W8oWht/amnpF" crossorigin="anonymous"></script>

    <!-- Option 2: Separate Popper and Bootstrap JS -->
    <!--
    <script src="https://cdn.jsdelivr.net/npm/jquery@3.5.1/dist/jquery.slim.min.js" integrity="sha384-DfXdz2htPH0lsSSs5nCTpuj/zy4C+OGpamoFVy38MVBnE+IbbVYUew+OrCXaRkfj" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.1/dist/umd/popper.min.js" integrity="sha384-9/reFTGAW83EW2RDu2S0VKaIzap3H66lZH81PoYlFhbGU+6BZp6G7niu735Sk7lN" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.1/dist/js/bootstrap.min.js" integrity="sha384-VHvPCCyXqtD5DqJeNxl2dtTyhF78xXNXdkwX1CZeRusQfRKp+tA7hAShOK/B/fQ2" crossorigin="anonymous"></script>
    -->
</body>

</html>